 ; Ŀ
 ;   Panic - Electrical Distribution Panel maker.                          
 ;   Copyright 2002 by Rocket Software Ltd.                                
 ;                                                                         
 ; 

 ; Ŀ
 ;   Bcnofne - draw a series of vertical lines.                            
 ;   Arguments: Pa, a base point.                                          
 ;              Vlen, the common length.  (Lines are drawn down.)          
 ;              Oflst, a list of offsets right from Pa.                    
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN BCNOFNE (pa vlen oflist / pb)
  (mapcar '(lambda (offdis)
            (command ".line" (setq pb (polar pa 0 offdis))
                             (polar pb down vlen) ""))
           oflist)
 (princ))
 ; Ŀ
 ;   Bcnofne end.                                                          
 ; 

 ; Ŀ
 ;   Bl3nk - draw a three phase breaker line.                              
 ;   Argument: Pa, the start point - not the line start.                   
 ;   Calls nothing, returns nothing.                                       
 ;   Sets the global variable dpos3 which indicates the right, middle, or  
 ;   left dot position and which should be local to the calling function.  
 ; 
 (DEFUN BL3NK (pa / pb pdot pc parc1 pacen parc2)
  (setq pb (polar (polar pa down 3.75) 0 2.5))
  (cond ((or (null dpos3) (= dpos3 "A"))
         (setq dpos3 "B")
         (setq pdot (polar pb 0 15)))
        ((= dpos3 "B")
         (setq dpos3 "C")
         (setq pdot (polar pb 0 22.5)))
        ((= dpos3 "C")
         (setq dpos3 "A")
         (setq pdot (polar pb 0 30))))
  (command ".insert" "dot" pdot 1 1 0)
  (setq pc (polar pb 0 3.75))
  (command ".line" pb pc "")
  (setq parc1 (polar pc (/ pi 2) 1.25))
  (setq pacen (polar (polar pc down 3.75) 0 3.75))
  (setq parc2 (polar parc1 0 7.5))
  (command ".arc" parc2 "c" pacen parc1)
  (setq pb (polar pc 0 7.5))
  (setq pc (polar pb 0 22.5))
  (command ".line" pb pc "")
  (setq parc1 (polar pc (/ pi 2) 1.25))
  (setq pacen (polar (polar pc down 3.75) 0 3.75))
  (setq parc2 (polar parc1 0 7.5))
  (command ".arc" parc2 "c" pacen parc1)
  (setq pb (polar pc 0 7.5))
  (setq pc (polar pb 0 3.75))
  (command ".line" pb pc "")
 (princ))
 ; Ŀ
 ;   Bl3nk end.                                                            
 ; 

 ; Ŀ
 ;   Blink - draw a single phase breaker line.                             
 ;   Argument: Pa, the start point - not the line start.                   
 ;   Calls nothing, returns nothing.                                       
 ;   Sets the global variable dpos which indicates the right or left dot   
 ;   position and which should be local to the calling function.           
 ; 
 (DEFUN BLINK (pa / pb pdot pc parc1 pacen parc2)
  (setq pb (polar (polar pa down 3.75) 0 2.5))
  (if (= dpos "B")
      (progn
           (setq dpos "A")
           (setq pdot (polar pb 0 23.75)))
      (progn
           (setq dpos "B")
           (setq pdot (polar pb 0 16.25))))
  (command ".insert" "dot" pdot 1 1 0)
  (setq pc (polar pb 0 3.75))
  (command ".line" pb pc "")
  (setq parc1 (polar pc (/ pi 2) 1.25))
  (setq pacen (polar (polar pc down 3.75) 0 3.75))
  (setq parc2 (polar parc1 0 7.5))
  (command ".arc" parc2 "c" pacen parc1)
  (setq pb (polar pc 0 7.5))
  (setq pc (polar pb 0 17.5))
  (command ".line" pb pc "")
  (setq parc1 (polar pc (/ pi 2) 1.25))
  (setq pacen (polar (polar pc down 3.75) 0 3.75))
  (setq parc2 (polar parc1 0 7.5))
  (command ".arc" parc2 "c" pacen parc1)
  (setq pb (polar pc 0 7.5))
  (setq pc (polar pb 0 3.75))
  (command ".line" pb pc "")
 (princ))
 ; Ŀ
 ;   Blink end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Calk: see whether the various values are ok.               
 ;   If so and the callback was the result of an <Enter> (Reason = 1)      
 ;   in the Other box then return a list of the number of circuits and     
 ;   one or three phase.                                                   
 ;   The Ok button returns two numbers: a 2 immediately followed by a 1.   
 ;   They are interpreted sequentially - the 2 doesn't block the 1.        
 ;                                                                         
 ;   Conditions for accepting the dialog box contents:                     
 ;   A button is selected, if it is an Other button then there is a        
 ;   number in the Other edit box.                                         
 ; 
 (DEFUN CALK (reason / ccts phase typ retlst)
  (cond ((= "1" (get_tile "single8"))
         (setq ccts 8)
         (setq phase 1))
        ((= "1" (get_tile "single20"))
         (setq ccts 20)
         (setq phase 1))
        ((= "1" (get_tile "single32"))
         (setq ccts 32)
         (setq phase 1))
        ((= "1" (get_tile "single42"))
         (setq ccts 42)
         (setq phase 1))
        ((= "1" (get_tile "other1"))
         (setq phase 1)
         (setq ccts (read (get_tile "edit_dat"))))
        ((= "1" (get_tile "three6"))
         (setq ccts 6)
         (setq phase 3))
        ((= "1" (get_tile "three18"))
         (setq ccts 18)
         (setq phase 3))
        ((= "1" (get_tile "three24"))
         (setq ccts 24)
         (setq phase 3))
        ((= "1" (get_tile "three42"))
         (setq ccts 42)
         (setq phase 3))
        ((= "1" (get_tile "other3"))
         (setq phase 3)
         (setq ccts (read (get_tile "edit_dat")))))
  (setq typ (type ccts))
  (cond ((or (null phase) (= "" phase))
         (set_tile "babtext" "No Phase selected."))
        ((or (null ccts) (= "" ccts))
         (set_tile "babtext" "No Circuits value selected."))
        ((/= typ 'INT)
         (set_tile "babtext" "Circuits Value is not a number."))
        ((and ccts phase (= reason 1))
         (setq retlst (list phase ccts))
         (done_dialog))
        ((and ccts phase)
         (set_tile "babtext" "")
         (setq retlst ())))
 retlst)
 ; Ŀ
 ;   Calk end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Calm - call a dialog box to phase and No. of circuits.     
 ;   Calls Onone, Onthre, and Calk.                                        
 ; 
 (DEFUN CALM (/ palst)
  (setq dcl_id (load_dialog "panic.dcl"))
  (new_dialog "panic" dcl_id)          ; must come before data for box
  (set_tile "other" "")
  (action_tile "single8"  "(onone)")   ; clear threes, enable or grey out box
  (action_tile "single20" "(onone)")
  (action_tile "single32" "(onone)")
  (action_tile "single42" "(onone)")
  (action_tile "other1"   "(onone)")
  (action_tile "three6"   "(onthre)")  ; clear ones, enable/grey out edit box
  (action_tile "three18"  "(onthre)")
  (action_tile "three24"  "(onthre)")
  (action_tile "three42"  "(onthre)")
  (action_tile "other3"   "(onthre)")
  (action_tile "edit_dat" "(setq palst (calk $reason))")
  (action_tile "edit_ok"  "(setq palst (calk 1))")
  (action_tile "editcancel" "(setq palst ())")
  (start_dialog)
  (unload_dialog dcl_id)
 palst)
 ; Ŀ
 ;   Calm end.                                                             
 ; 

 ; Ŀ
 ;   Hlinak - draw a series of horizontal lines.                           
 ;   Arguments: Pa, a base point.                                          
 ;              Hlen, the common length.  (Lines are drawn to the right.)  
 ;              Oflst, a list of offsets down from Pa.                     
 ;   Calls nothing, returns nothing.                                       
 ;                                                                         
 ; 
 (DEFUN HLINAK (pa hlen oflist / pb)
  (mapcar '(lambda (offdis)
            (command ".line" (setq pb (polar pa down offdis))
                             (polar pb 0 hlen) ""))
           oflist)
 (princ))
 ; Ŀ
 ;   Hlinak end.                                                           
 ; 

 ; Ŀ
 ;   Ma3br - draw three single phase breakers.                             
 ;   Argument: Pa, the ul corner of the surrounding box.                   
 ;   Calls nothing, returns a list of the three bus line start points.     
 ; 
 (DEFUN MA3BR (pa / pb pb1 pb2 pc pc1 pc2 parc1 pamid parc2 pamid1)
  (setq pb (polar (polar pa down 12.5) 0 17.5))
 ; Ŀ
 ;   Draw the contact circles.                                             
 ; 
  (command ".circle" pb 1.25)
  (command ".circle" (setq pb1 (polar pb 0 7.5)) 1.25)
  (command ".circle" (setq pb2 (polar pb 0 15)) 1.25)
  (command ".circle" (setq pc (polar pb down 10)) 1.25)
  (command ".circle" (setq pc1 (polar pb1 down 10)) 1.25)
  (command ".circle" (setq pc2 (polar pb2 down 10)) 1.25)
 ; Ŀ
 ;   The first arc.                                                        
 ; 
  (setq parc1 (polar pb 0 3))
  (setq pamid (polar (polar parc1 down 5) 0 2))
  (setq parc2 (polar parc1 down 10))
  (command ".arc" parc2 pamid parc1)
 ; Ŀ
 ;   The second arc.                                                       
 ; 
  (setq parc1 (polar pb1 0 3))
  (setq pamid1 (polar (polar parc1 down 5) 0 2))
  (setq parc2 (polar parc1 down 10))
  (command ".arc" parc2 pamid1 parc1)
 ; Ŀ
 ;   The third arc.                                                        
 ; 
  (setq parc1 (polar pb2 0 3))
  (setq pamid1 (polar (polar parc1 down 5) 0 2))
  (setq parc2 (polar parc1 down 10))
  (command ".arc" parc2 pamid1 parc1)
 ; Ŀ
 ;   The line between breaker arcs.                                        
 ; 
  (command ".line" pamid pamid1 "")
 ; Ŀ
 ;   Return the bus contact points.                                        
 ; 
 (list (polar pc down 1.25)
       (polar pc1 down 1.25)
       (polar pc2 down 1.25)))
 ; Ŀ
 ;   Ma3br end.                                                            
 ; 

 ; Ŀ
 ;   Maibr - draw a pair of single phase breakers.                         
 ;   Argument: Pa, the ul corner of the surrounding box.                   
 ;   Calls nothing, returns a list of the two bus line start points.       
 ; 
 (DEFUN MAIBR (pa / pb pb1 pc parc1 pamid parc2 pamid1)
  (setq pb (polar (polar pa down 12.5) 0 18.75))
  (command ".circle" pb 1.25)
  (command ".circle" (setq pb1 (polar pb 0 7.5)) 1.25)
  (command ".circle" (setq pc (polar pb down 10)) 1.25)
  (command ".circle" (polar pc 0 7.5) 1.25)
  (setq parc1 (polar pb 0 3))
  (setq pamid (polar (polar parc1 down 5) 0 2))
  (setq parc2 (polar parc1 down 10))
  (command ".arc" parc2 pamid parc1)
  (setq parc1 (polar parc1 0 7.5))
  (setq pamid1 (polar pamid 0 7.5))
  (setq parc2 (polar parc2 0 7.5))
  (command ".arc" parc2 pamid1 parc1)
  (command ".line" pamid pamid1 "")
 (list (polar pc down 1.25) (polar pb1 down 11.25)))
 ; Ŀ
 ;   Maibr end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Onone: respond to a single phase radio button click.       
 ;   Clear the three phase radio buttons, enable or disable the Other      
 ;   edit box as required.                                                 
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN ONONE (/)
  (set_tile "three6" "0")
  (set_tile "three18" "0")
  (set_tile "three24" "0")
  (set_tile "three42" "0")
  (set_tile "other3" "0")
  (set_tile "babtext" "")
  (if (= (get_tile "other1") "1")
      (mode_tile "edit_dat" 0)
      (mode_tile "edit_dat" 1)))
 ; Ŀ
 ;   Subroutine Onone end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Onthre: respond to a three phase radio button click.       
 ;   Clear the single phase radio buttons, enable or disable the Other     
 ;   edit box as required.                                                 
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN ONTHRE (/)
  (set_tile "single8" "0")
  (set_tile "single20" "0")
  (set_tile "single32" "0")
  (set_tile "single42" "0")
  (set_tile "other1" "0")
  (set_tile "babtext" "")
  (if (= (get_tile "other3") "1")
      (mode_tile "edit_dat" 0)
      (mode_tile "edit_dat" 1)))
 ; Ŀ
 ;   Subroutine Onthre end.                                                
 ; 

 ; Ŀ
 ;   Rotifer - install a row of text.                                      
 ;   Arguments: Pa, the base point.                                        
 ;              Oflst, a list of offsets right from Pa.                    
 ;              Txlist, a list of strings.                                 
 ;              Alglst, a list of text justifications.                     
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN ROTIFER (pa oflist txlist alglst / pb)
  (setq pb (polar (polar pa down 3.75) 0 2.5))
  (mapcar '(lambda (offdis txstr alig)
            (command ".text" alig (polar pb 0 offdis) 2.5 0 txstr))
           oflist txlist alglst)
 (princ))
 ; Ŀ
 ;   Rotifer end.                                                          
 ; 

 ; Ŀ
 ;   Panic.                                                                
 ; 
 (DEFUN C:PANIC (/ down palist circts phase rows ovrlht pa pur plr pa1 brkrht
                        pb1 pb2 pn pn2 ent1 ent2 pabr buslen plist pb3 num ptx
                                    num1 num2 dpos dpos3 oflist alglst txlist)
  (setvar "cmdecho" 0)
  (setvar "osmode" 0)
  (command "undo" "be")
  (setq down (* pi 1.5))  ; the angle of the same name
  (defun setblu () (setvar "cecolor" "blue"))
  (defun setyel () (setvar "cecolor" "yellow"))
  (defun setcya () (setvar "cecolor" "cyan"))
  (defun setby () (setvar "cecolor" "bylayer"))
 ; Ŀ
 ;   Call Pa, the dialog box handler, which returns a list:                
 ;   Phases and circuits.                                                  
 ; 
  (if (setq palist (calm))
      (progn
           (setq circts (nth 1 palist))
           (setq phase (nth 0 palist))))
 ; Ŀ
 ;   Deduce the number of rows from the number of circuits.                
 ; 
  (setq rows (/ circts 2.0))
  (if (/= rows (fix rows))
      (progn
           (setq rows (fix (1+ rows)))
           (prompt "\nUneven number of circuits fixed."))
      (setq rows (fix rows)))
  (setq ovrlht (+ (* rows 7.5) 47.5 25))
  (setq pa (getpoint "\nUpper left corner: "))
 ; Ŀ
 ;   Get layers ready.                                                     
 ; 
  (if (null c:malaya) (load "malaya"))
  (malaya "text")
  (malaya "misc")
 ; Ŀ
 ;   First draw the more-or-less fixed stuff.                              
 ;   Draw the panel outline.                                               
 ; 
  (setcya)
  (command "pline" pa (setq pur (polar pa 0 280))
                      (setq plr (polar pur down ovrlht))
                      (polar plr pi 280) "c")
 ; Ŀ
 ;   Header and base horizontal lines.                                     
 ; 
  (hlinak pa 280 (list 10 45 47.5 (+ 47.5 (* rows 7.5)) (+ 50 (* rows 7.5))))
 ; Ŀ
 ;   Vertical column lines.                                                
 ; 
  (setyel)
  (setq pa1 (polar pa down 10))
  (setq brkrht (+ 37.5 (* rows 7.5)))
  (if (= phase 1)
      (bcnofne pa1 brkrht (list 87.5 97.5 107.5 117.5 162.5 172.5 182.5 192.5))
      (bcnofne pa1 brkrht (list 85 95 105 115 165 175 185 195)))
 ; Ŀ
 ;   Vertical base section dividers.                                       
 ; 
  (setcya)
  (if (= phase 1)
      (setq pb1 (polar (polar pa down (+ brkrht 12.5)) 0 97.5))
      (setq pb1 (polar (polar pa down (+ brkrht 12.5)) 0 95)))
  (setq pb2 (polar pb1 down 22.5))
  (command ".line" pb1 pb2 "")
  (if (= phase 1)
      (command ".line" (polar pb1 0 85) (polar pb2 0 85) "")
      (command ".line" (polar pb1 0 90) (polar pb2 0 90) ""))
 ; Ŀ
 ;   Solid Neutral symbology.                                              
 ; 
  (setby)
  (setq pn (polar (polar pb1 down 8.5) 0 42.5))
  (setq pn2 (polar pn down 4))
  (command ".line" pn pn2 "")
  (command ".insert" "dot" pn2 1 1 0)
  (command ".line" (polar pn2 pi 10) (polar pn2 0 10) "")
  (setby)
  (malaya "text")
  (command ".text" "M" (polar pn2 down 5) 3 0 "SOLID NEUTRAL")
 ; Ŀ
 ;   Various header text.                                                  
 ; 
  (setblu)
  (setq pn (polar (polar pa down 5) 0 140))
  (command ".text" "m" pn 4 0 "LIGHTING PANEL `A'")
  (setby)
  (if (= phase 1)
      (command ".text" "mr" (polar pn 0 135) 3 0 "120/208V, 1%%C, 3 WIRE")
      (command ".text" "mr" (polar pn 0 135) 3 0 "120/208V, 3%%C, 4 WIRE"))
 ; Ŀ
 ;   Connected load header.                                                
 ; 
  (if (= phase 1)
      (setq pn (polar (polar pa down 27.5) 0 90.5))
      (setq pn (polar (polar pa down 27.5) 0 88)))
  (command ".text" "m" pn 2.5 90 "CONNECTED")
  (setq ent1 (entlast))
  (command ".text" "m" (polar pn 0 4) 2.5 90 "LOAD")
  (setq ent2 (entlast))
  (if (= phase 1)
      (command ".copy" ent1 ent2 "" "95,0" "")
      (command ".copy" ent1 ent2 "" "100,0" ""))
 ; Ŀ
 ;   Breaker Size header.                                                  
 ; 
  (setq pn (polar pn 0 10))
  (command ".text" "m" pn 2.5 90 "BREAKER SIZE")
  (setq ent1 (entlast))
  (command ".text" "m" (polar pn 0 4) 2.5 90 "(AMPS)")
  (setq ent2 (entlast))
  (if (= phase 1)
      (command ".copy" ent1 ent2 "" "75,0" "")
      (command ".copy" ent1 ent2 "" "80,0" ""))
 ; Ŀ
 ;   Curcuit No. header.                                                   
 ; 
  (setq pn (polar pn 0 12))
  (command ".text" "m" pn 2.5 90 "CIRCUIT No.")
  (setq ent1 (entlast))
  (if (= phase 1)
      (command ".copy" ent1 "" "55,0" "")
      (command ".copy" ent1 "" "60,0" ""))
 ; Ŀ
 ;   Location prototype text for base area.                                
 ; 
  (setq pn (polar (polar pa down (+ 53.75 (* rows 7.5))) 0 2.5))
  (command ".text" "ml" pn 2.5 0 "LOCATED IN OFFICE/ELECTRICAL BLDG.")
 ; Ŀ
 ;   Breakers, lines, and connecting dots.                                 
 ; 
  (malaya "misc")
  (if (= phase 1)
      (setq pabr (polar (polar pa down 47.5) 0 117.5))
      (setq pabr (polar (polar pa down 47.5) 0 115)))
  (repeat rows
          (if (= phase 1) (blink pabr) (bl3nk pabr))
          (setq pabr (polar pabr down 7.5)))
 ; Ŀ
 ;   Main breakers and bus lines.                                          
 ; 
  (setq buslen (+ 13.75 (- (* rows 7.5) 2.5)))
  (if (= phase 1)
      (progn
           (setq pabr (polar (polar pa down 10) 0 117.5))
           (setq plist (maibr pabr)))
      (progn
           (setq pabr (polar (polar pa down 10) 0 115))
           (setq plist (ma3br pabr))))
  (setq pb1 (car plist))
  (setq pb2 (cadr plist))
  (setq pb3 (caddr plist))
  (setcya)
  (command ".line" pb1 (polar pb1 down buslen) "")
  (command ".line" pb2 (polar pb2 down buslen) "")
  (if pb3 (command ".line" pb3 (polar pb3 down buslen) ""))
 ; Ŀ
 ;   Breaker row dividing lines.                                           
 ; 
 ; Need a way to describe rows, which have 2 and 3 pole breakers.
 ; Read input text into a list, the first element is how many rows to
 ; use up.  Everything else runs off that.  So this next section will have
 ; to be modified.
 ; Need a thing to read a .cdf file into a structured format...list...thing.
  (setyel)
  (setq num 47.5)
  (setq plist ())
  (repeat (1- rows)
          (setq num (+ num 7.5))
          (setq plist (cons num plist)))
  (if (= phase 1)
      (progn
           (hlinak pa 117.5 plist)
           (hlinak (polar pa 0 162.5) 117.5 plist))
      (progn
           (hlinak pa 115 plist)
           (hlinak (polar pa 0 165) 115 plist)))
 ; Ŀ
 ;   Text.                                                                 
 ; 
  (setvar "clayer" "text")
  (setby)
  (setq ptx (polar pa down 47.5))
  (setq num1 1)
  (setq num2 2)
  (if (= phase 1)
      (setq oflist (list 0 90 100 110 165 175 185 192.5))
      (setq oflist (list 0 87.5 97.5 107.5 167.5 177.5 187.5 195)))
  (setq alglst (list "ml" "m" "m" "m" "m" "m" "m" "ml"))
  (repeat rows
         (setq txlist (list "SPARE" "-" "-" num1 num2 "-" "-" "SPARE"))
         (rotifer ptx oflist txlist alglst)
         (setq num1 (+ num1 2))
         (setq num2 (+ num2 2))
         (setq ptx (polar ptx down 7.5)))
  (command "undo" "end")
 (princ))